<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Ona Blava | Barcelona Mediterranean Design</title>
    <link rel="stylesheet" href="css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@700;800&family=Open+Sans:wght@400;600&display=swap" rel="stylesheet">
</head>
<body>
    <nav>
        <div class="logo">ONA BLAVA</div>
        <ul>
            <li><a href="index.php">Inicio</a></li>
            <li><a href="historia.php">Nuestra Historia</a></li>
            <li><a href="contacto.php">Contacto</a></li>
        </ul>
    </nav>

    <section class="hero" style="background-image: linear-gradient(rgba(0,0,0,0.3), rgba(0,0,0,0.3)), url('img/hero-beach-pareo.jpg');">
        <div>
            <h1>Alma Mediterránea</h1>
            <p style="font-size: 1.2rem; margin: 20px 0 30px;">Pareos de diseño nacidos en el corazón de Barcelona.</p>
            <a href="#coleccion" class="btn primary-btn">Ver Colección</a>
        </div>
    </section>

    <section id="coleccion" style="padding: 80px 8%; text-align: center;">
        <h2 style="margin-bottom: 50px;">Colección 2024</h2>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 30px;">
            <div class="card"><img src="img/pareo-gaudi.jpg" style="width:100%; border-radius:10px;"><h3>Gaudí Dream</h3></div>
            <div class="card"><img src="img/pareo-logo.jpg" style="width:100%; border-radius:10px;"><h3>Ona Signature</h3></div>
            <div class="card"><img src="img/pareo-moderno.jpg" style="width:100%; border-radius:10px;"><h3>Urban Wave</h3></div>
        </div>
    </section>

    <footer>
        <div class="footer-grid">
            <div class="footer-col"><h4>Ona Blava</h4><p>Barcelona Est. 2024</p></div>
            <div class="footer-col"><h4>Enlaces</h4><ul><li><a href="historia.php">Historia</a></li><li><a href="contacto.php">Contacto</a></li></ul></div>
            <div class="footer-col"><h4>Redes</h4><ul><li><a href="#">Instagram</a></li><li><a href="#">TikTok</a></li></ul></div>
        </div>
    </footer>
</body>
</html>