<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ona Blava | Pareos de Diseño Barcelona</title>
    <link rel="stylesheet" href="css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@700&family=Open+Sans&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>
<body>
    <header>
        <nav class="main-nav">
            <div class="logo">ONA BLAVA</div>
            <ul>
                <li><a href="index.php">Inicio</a></li>
                <li><a href="historia.php">Nuestra Historia</a></li>
                <li><a href="contacto.php">Contacto</a></li>
            </ul>
        </nav>
    </header>

    <main>
        <section class="hero-carousel">
            <div class="carousel-item active">
                <img src="img/hero-beach-pareo.jpg" alt="Pareo Ona Blava en la playa" class="carousel-bg">
                <div class="carousel-content">
                    <h1>Ona Blava: Donde el Diseño Encuentra el Mar</h1>
                    <p>Pareos únicos, creados en Barcelona, para tu estilo mediterráneo.</p>
                    <a href="#coleccion" class="btn primary-btn">Descubre la Colección</a>
                </div>
            </div>
            </section>

        <section class="essence-section">
            <div class="essence-content">
                <h2>La Esencia de Barcelona en Cada Fibra</h2>
                <p>En Ona Blava, fusionamos la vibrante energía urbana de Barcelona con la serenidad infinita del Mediterráneo. Cada pareo es una declaración de estilo, una pieza de arte portátil que te acompaña desde la playa hasta la ciudad.</p>
                <a href="historia.php" class="btn secondary-btn">Conoce Nuestra Historia</a>
            </div>
            <div class="essence-image">
                <img src="img/founders-story.jpg" alt="Diego y Andrés fundadores de Ona Blava">
            </div>
        </section>

        <section id="coleccion" class="featured-collection">
            <h2>Nuestra Colección Destacada</h2>
            <div class="collection-grid">
                <div class="collection-card">
                    <img src="img/pareo-gaudi.jpg" alt="Pareo inspirado en Gaudí">
                    <h3>Gaudí Mosaic Dream</h3>
                    <p>Inspiración artística en cada detalle.</p>
                    <a href="#" class="btn tertiary-btn">Ver Producto</a>
                </div>
                <div class="collection-card">
                    <img src="img/pareo-logo.jpg" alt="Pareo con logo de Ona Blava">
                    <h3>Identidad Ona Blava</h3>
                    <p>La esencia de nuestra marca en un diseño único.</p>
                    <a href="#" class="btn tertiary-btn">Ver Producto</a>
                </div>
                <div class="collection-card">
                    <img src="img/pareo-costabrava.jpg" alt="Pareo Costa Brava">
                    <h3>Paisajes de la Costa Brava</h3>
                    <p>La belleza salvaje y natural del Mediterráneo.</p>
                    <a href="#" class="btn tertiary-btn">Ver Producto</a>
                </div>
            </div>
            <div class="view-all">
                <a href="#" class="btn primary-btn">Ver Toda la Colección</a>
            </div>
        </section>

        <section class="cta-section">
            <div class="cta-content">
                <h2>¿Listo para vivir la experiencia Ona Blava?</h2>
                <p>Descubre tu pareo perfecto y lleva contigo la magia de Barcelona.</p>
                <a href="#coleccion" class="btn primary-btn">Compra Ahora</a>
            </div>
        </section>
    </main>

    <footer class="footer-ext">
        <div class="footer-container">
            <div class="footer-col">
                <h3 class="logo-footer">ONA BLAVA</h3>
                <p>Barcelona Est. 2024. Diseño con alma mediterránea.</p>
            </div>

            <div class="footer-col">
                <h4>Explora</h4>
                <ul>
                    <li><a href="index.php">Colección</a></li>
                    <li><a href="historia.php">Sobre Nosotros</a></li>
                    <li><a href="contacto.php">Ayuda</a></li>
                </ul>
            </div>

            <div class="footer-col">
                <h4>Síguenos</h4>
                <div class="social-links">
                    <a href="https://instagram.com/onablava" target="_blank"><i class="fab fa-instagram"></i> Instagram</a>
                    <a href="https://tiktok.com/@onablava" target="_blank"><i class="fab fa-tiktok"></i> TikTok</a>
                    <a href="https://pinterest.com/onablava" target="_blank"><i class="fab fa-pinterest"></i> Pinterest</a>
                </div>
            </div>

            <div class="footer-col">
                <h4>Legal</h4>
                <ul>
                    <li><a href="#">Aviso Legal</a></li>
                    <li><a href="#">Política de Privacidad</a></li>
                    <li><a href="#">Cookies</a></li>
                </ul>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; 2026 Ona Blava Barcelona. Creado por Diego y Andrés.</p>
        </div>
    </footer>

</body>
</html>